/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.plugin.audit;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Calendar;
import org.apache.doris.plugin.audit.AuditLoaderPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DorisStreamLoader {
    private static final Logger LOG = LogManager.getLogger(DorisStreamLoader.class);
    private static String loadUrlPattern = "http://%s/api/%s/%s/_stream_load?";
    private String hostPort;
    private String db;
    private String auditLogTbl;
    private String slowLogTbl;
    private String user;
    private String passwd;
    private String auditLogLoadUrlStr;
    private String slowLogLoadUrlStr;
    private String authEncoding;
    private String feIdentity;

    public DorisStreamLoader(AuditLoaderPlugin.AuditLoaderConf conf) {
        this.hostPort = conf.frontendHostPort;
        this.db = conf.database;
        this.auditLogTbl = conf.auditLogTable;
        this.slowLogTbl = conf.slowLogTable;
        this.user = conf.user;
        this.passwd = conf.password;
        this.auditLogLoadUrlStr = String.format(loadUrlPattern, this.hostPort, this.db, this.auditLogTbl);
        this.slowLogLoadUrlStr = String.format(loadUrlPattern, this.hostPort, this.db, this.slowLogTbl);
        this.authEncoding = Base64.getEncoder().encodeToString(String.format("%s:%s", this.user, this.passwd).getBytes(StandardCharsets.UTF_8));
        this.feIdentity = conf.feIdentity.replaceAll("\\.", "_");
    }

    private HttpURLConnection getConnection(String urlStr, String label, String clusterToken) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("token", clusterToken);
        conn.setRequestProperty("Authorization", "Basic " + this.authEncoding);
        conn.addRequestProperty("Expect", "100-continue");
        conn.addRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        conn.addRequestProperty("label", label);
        conn.addRequestProperty("max_filter_ratio", "1.0");
        conn.addRequestProperty("columns", "query_id, `time`, client_ip, user, db, state, error_code, error_message, query_time, scan_bytes, scan_rows, return_rows, stmt_id, is_query, frontend_ip, cpu_time_ms, sql_hash, sql_digest, peak_memory_bytes, stmt");
        conn.addRequestProperty("redirect-policy", "random-be");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        return conn;
    }

    private String toCurl(HttpURLConnection conn) {
        StringBuilder sb = new StringBuilder("curl -v ");
        sb.append("-X ").append(conn.getRequestMethod()).append(" \\\n  ");
        sb.append("-H \"").append("Authorization\":").append("\"Basic " + this.authEncoding).append("\" \\\n  ");
        sb.append("-H \"").append("Expect\":").append("\"100-continue\" \\\n  ");
        sb.append("-H \"").append("Content-Type\":").append("\"text/plain; charset=UTF-8\" \\\n  ");
        sb.append("-H \"").append("max_filter_ratio\":").append("\"1.0\" \\\n  ");
        sb.append("-H \"").append("columns\":").append("\"query_id, time, client_ip, user, db, state, error_code, error_message, query_time, scan_bytes, scan_rows, return_rows, stmt_id, is_query, frontend_ip, cpu_time_ms, sql_hash, sql_digest, peak_memory_bytes, stmt\" \\\n  ");
        sb.append("\"").append(conn.getURL()).append("\"");
        return sb.toString();
    }

    private String getContent(HttpURLConnection conn) {
        BufferedReader br = null;
        StringBuilder response = new StringBuilder();
        try {
            String line;
            br = 100 <= conn.getResponseCode() && conn.getResponseCode() <= 399 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            LOG.warn("get content error,", (Throwable)e);
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadResponse loadBatch(StringBuilder sb, boolean slowLog, String clusterToken) {
        Calendar calendar = Calendar.getInstance();
        String label = String.format("_log_%s%02d%02d_%02d%02d%02d_%s", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), this.feIdentity);
        HttpURLConnection feConn = null;
        HttpURLConnection beConn = null;
        try {
            if (slowLog) {
                label = "slow" + label;
                feConn = this.getConnection(this.slowLogLoadUrlStr, label, clusterToken);
            } else {
                label = "audit" + label;
                feConn = this.getConnection(this.auditLogLoadUrlStr, label, clusterToken);
            }
            int status = feConn.getResponseCode();
            if (status != 307) {
                throw new Exception("status is not TEMPORARY_REDIRECT 307, status: " + status + ", response: " + this.getContent(feConn) + ", request is: " + this.toCurl(feConn));
            }
            String location = feConn.getHeaderField("Location");
            if (location == null) {
                throw new Exception("redirect location is null");
            }
            beConn = this.getConnection(location, label, clusterToken);
            BufferedOutputStream bos = new BufferedOutputStream(beConn.getOutputStream());
            bos.write(sb.toString().getBytes());
            bos.close();
            status = beConn.getResponseCode();
            String respMsg = beConn.getResponseMessage();
            String response = this.getContent(beConn);
            LOG.info("AuditLoader plugin load with label: {}, response code: {}, msg: {}, content: {}", (Object)label, (Object)status, (Object)respMsg, (Object)response);
            LoadResponse loadResponse = new LoadResponse(status, respMsg, response);
            return loadResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "failed to load audit via AuditLoader plugin with label: " + label;
            LOG.warn(err, (Throwable)e);
            LoadResponse loadResponse = new LoadResponse(-1, e.getMessage(), err);
            return loadResponse;
        }
        finally {
            if (feConn != null) {
                feConn.disconnect();
            }
            if (beConn != null) {
                beConn.disconnect();
            }
        }
    }

    public static class LoadResponse {
        public int status;
        public String respMsg;
        public String respContent;

        public LoadResponse(int status, String respMsg, String respContent) {
            this.status = status;
            this.respMsg = respMsg;
            this.respContent = respContent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("status: ").append(this.status);
            sb.append(", resp msg: ").append(this.respMsg);
            sb.append(", resp content: ").append(this.respContent);
            return sb.toString();
        }
    }
}

